<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/datatables.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/scrollbar.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/datatable-extension.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/prism.css')); ?>">

<?php $__env->stopSection(); ?>


<?php $__env->startSection('main_content'); ?>
    <div class="container-fluid">
        <div class="row page-title">
            <div class="col-sm-6">
                <h3>Roles de Usuario</h3>
            </div>
            <div class="col-sm-6">
                <nav>
                    <ol class="breadcrumb justify-content-sm-end align-items-center">
                        <li class="breadcrumb-item"> <a href="<?php echo e(route('Main.Desktop')); ?>">
                                <svg class="svg-color">
                                    <use href="<?php echo e(asset('assets/svg/iconly-sprite.svg#Home')); ?>"></use>
                                </svg></a></li>
                        <li class="breadcrumb-item">Sistema</li>
                        <li class="breadcrumb-item active">Roles de Usuario</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option f-16">
                                <li><i class="icon-more-alt"></i></li>
                                <!--<li><i class="view-html fa fa-code"></i></li>-->
                                <li><a href="<?php echo e(route('System.NewRol')); ?>" title="Nuevo"><i class="icofont icofont-plus-circle"></i></a></li>
                                <li><a href=""><i class="icofont icofont-maximize full-card"></i></a></li>
                                <li><a href="#"><i class="icofont icofont-minus minimize-card"></i></a></li>
                                <!--<li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li> -->
                            </ul>
                        </div>

                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-3 pills-blogger">
                            <div class="col-sm-12">
                                            <div class="table-responsive theme-scrollbar">
                                                <table class="display" id="RolesMaster" class="basic_table" style="width:100%">
                                                    <thead>
                                                        <tr>
                                                            <th>ID</th>
                                                            <th>NOMBRE</th>
                                                            <th>PROPOSITO</th>
                                                            <th>APLICACION</th>
                                                            <th>ESTADO</th>
                                                            <th>...</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        <?php $__currentLoopData = $Roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Rol): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                            <tr>
                                                                <td><?php echo e($Rol->id_perfil); ?></td>
                                                                <td><?php echo e($Rol->nombre); ?></td>
                                                                <td><?php echo e($Rol->proposito); ?></td>
                                                                <td><?php echo e($Rol->aplicacion); ?></td>
                                                                <td>
                                                                    <div class="form-check-size">
                                                                        <div class="form-check form-switch form-check-inline">
                                                                            <?php if($Rol->id_estado == 'PA'): ?>
                                                                                    <input class="form-check-input check-size" id="<?php echo e($Rol->id_perfil); ?>" type="checkbox" role="switch" checked="checked" title="Estado del Rol" onchange="SetStatusRolTable('<?php echo e($Rol->id_perfil); ?>');">
                                                                            <?php else: ?>
                                                                                    <input class="form-check-input check-size" id="<?php echo e($Rol->id_perfil); ?>" type="checkbox" role="switch" title="Estado del Rol" onchange="SetStatusRolTable('<?php echo e($Rol->id_perfil); ?>');">
                                                                            <?php endif; ?>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <a href="<?php echo e(route('System.EditRol', ['IdRol'=>$Rol->id_perfil])); ?>"
                                                                        class="m-0 btn-xs p-1 btn-outline-primary"
                                                                        type="button"
                                                                        title="Editar este registro"
                                                                        ><i class="icofont icon-pencil font-dark "></i>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                    </tbody>
                                                </table>
                                            </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid ends-->
    <!--Alert Post AJAX-->
    <?php echo $__env->make('Alerts.AlertToast', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<?php $__env->stopSection(); ?>

<?php $__env->startSection('scripts'); ?>
   <script src="<?php echo e(asset('assets/js/vendors/clipboard/dist/clipboard.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/clipboard/clipboard-script.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/prism/prism.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/custom-card/custom-card.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/gestor.js')); ?>"></script>

    <script src="<?php echo e(asset('assets/js/datatable/datatables/datatables.gestor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.buttons.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/jszip.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/buttons.colVis.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/pdfmake.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/vfs_fonts.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.autoFill.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.select.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/buttons.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/buttons.html5.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/buttons.print.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.responsive.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/responsive.bootstrap4.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.keyTable.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.colReorder.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.fixedHeader.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.rowReorder.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatable-extension/dataTables.scroller.min.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master_main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Dev\Laravel12\Gestor\resources\views/Admin/Roles.blade.php ENDPATH**/ ?>