<?php $__env->startSection('css'); ?>
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/datatables.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/scrollbar.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/select2/dist/css/select2.css')); ?>">
    <link rel="stylesheet" type="text/css" href="<?php echo e(asset('assets/css/vendors/prism.css')); ?>">

<?php $__env->stopSection(); ?>

<?php $__env->startSection('main_content'); ?>
<div class="container-fluid">
  <div class="row page-title">
      <div class="col-sm-6">
          <h3>Datos de Usuario</h3>
      </div>
      <div class="col-sm-6">
          <nav>
              <ol class="breadcrumb justify-content-sm-end align-items-center">
                  <li class="breadcrumb-item"> <a href="<?php echo e(route('Main.Desktop')); ?>">
                          <svg class="svg-color">
                              <use href="<?php echo e(asset('assets/svg/iconly-sprite.svg#Home')); ?>"></use>
                          </svg></a></li>
                  <li class="breadcrumb-item"><a href="<?php echo e(route('System.Users')); ?>">Usuarios</a></li>
                  <li class="breadcrumb-item">Registro de Usuarios</li>
              </ol>
          </nav>
      </div>
  </div>
</div>
<!--Alert de Actualización -->
    <?php echo $__env->make('Alerts.AlertUpdate', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
<!-- Container-fluid starts-->

        <div class="container-fluid edit-profile">
            <div class="row">
                <div class="card col-xl-8">
                    <div class="card-header">
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option f-16">
                                <li><i class="icon-more-alt"></i></li>
                                <!--<li><i class="view-html fa fa-code"></i></li>-->
                                <li><a href="<?php echo e(route('System.NewUser')); ?>" title="Nuevo"><i class="icofont icofont-plus-circle"></i></a></li>
                                <li><a href="<?php echo e(route('System.GenPasswd')); ?>" title="Generar Contraseña y enviar por correo"><i class="icofont icofont-lock"></i></a></li>
                                <li><a href="#"><i class="icofont icofont-maximize full-card"></i></a></li>
                                <li><a href="#"><i class="icofont icofont-minus minimize-card"></i></a></li>
                            </ul>
                        </div>
                    </div>
                    <!--Contenido del formulario datos de la cuenta-->
                    <div class="card-body">
                         <form action="<?php echo e(route('System.UpdateUser', ['id_usuario'=>$CurrentUser->id_usuario])); ?>" method="post" novalidate>
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Cuenta:</label>
                                            <input class="form-control" placeholder="email@domain.com" name="email"
                                                value="<?php echo e($CurrentUser->cuenta); ?>">
                                            <?php $__errorArgs = ['email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">E-mail alternativo:<span> *</span></label>
                                            <input class="form-control" type="email" placeholder="Email" name="email2"
                                                value="<?php echo e($CurrentUser->correo_electronico); ?>">
                                            <?php $__errorArgs = ['email2'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Nombre completo:<span> *</span></label>
                                            <input class="form-control" type="text" placeholder="Nombre completo" name="fullname"
                                                value="<?php echo e($CurrentUser->propietario); ?>">
                                            <?php $__errorArgs = ['fullname'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Teléfono fijo:</label>
                                            <input class="form-control" type="number" placeholder="Telefono" name="telfijo"
                                                value="<?php echo e($CurrentUser->telefono); ?>">
                                            <?php $__errorArgs = ['telfijo'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Domicilio:</label>
                                            <input class="form-control" type="text" placeholder="Direccion" name="domicilio"
                                                value="<?php echo e($CurrentUser->domicilio); ?>">
                                            <?php $__errorArgs = ['domicilio'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Teléfono Móvil:<span> *</span></label>
                                            <input class="form-control" type="number" name="celular"
                                                value="<?php echo e($CurrentUser->celular); ?>" placeholder="Número de Móvil">
                                            <?php $__errorArgs = ['celular'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label">Ciudad:</label>
                                            <input class="form-control" type="text" placeholder="Ciudad" name="ciudad"
                                                value="<?php echo e($CurrentUser->ciudad); ?>">
                                            <?php $__errorArgs = ['ciudad'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <span class="text-danger">
                                                    <strong><?php echo e($message); ?></strong>
                                                </span>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>
                                    </div>
                                    <div class="col-sm-6 col-md-6">
                                        <div class="mb-3">
                                            <label class="form-label" for="select">Rol de usuario:</label>
                                            <select class="form-select" id="id_perfil" name="id_perfil" >
                                                <?php $__currentLoopData = $Roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Rol): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                    <?php if($CurrentUser->id_perfil != $Rol->id_perfil): ?>
                                                        <option value = "<?php echo e($Rol->id_perfil); ?>"  ><?php echo e($Rol->nombre); ?></option>
                                                    <?php else: ?>
                                                        <option value = "<?php echo e($Rol->id_perfil); ?>"  selected ><?php echo e($Rol->nombre); ?></option>
                                                    <?php endif; ?>
                                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                            </select>
                                        </div>
                                    </div>
                                    <div class="col-sm-4 col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label">Fecha de creación:</label>
                                            <input class="form-control" type="text" placeholder="Ciudad" name="date1" disabled
                                                value="<?php echo e($CurrentUser->fecha_creacion); ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-4 col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label">Última actualización:</label>
                                            <input class="form-control" type="text" name="date2" disabled
                                                value="<?php echo e($CurrentUser->fecha_ultimo_cambio); ?>">
                                        </div>
                                    </div>
                                    <div class="col-sm-4 col-md-3">
                                        <div class="mb-3">
                                            <label class="form-label">Estado de la Cuenta:</label>
                                            <div class="form-check-size">
                                                <div class="form-check form-switch form-check-inline">
                                                    <?php if($CurrentUser->id_estado == 'CA'): ?>
                                                            <input class="form-check-input check-size" id="id_estado" name="id_estado" type="checkbox" role="switch" checked="checked" value="CA" title="Estado de la Cuenta" onchange="SetStatusUser('<?php echo e($CurrentUser->id_usuario); ?>', 'CA');">
                                                    <?php else: ?>
                                                            <input class="form-check-input check-size" id="id_estado" name="id_estado" type="checkbox" role="switch" title="Estado de la Cuenta" value="CI" onchange="SetStatusUser('<?php echo e($CurrentUser->id_usuario); ?>', 'CI');">
                                                    <?php endif; ?>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                            </div>
                            <hr>
                            <div class="row">
                                <div class="text-end">
                                    <button class="btn btn-primary" type="submit">Actualizar</button>
                                </div>
                            </div>
                         </form>
                    </div>
                    <!--Aqui termina le Form datos de la Cuenta-->
                </div>
                <!--Seccion de la derecha-->
                <div class="col-xl-4">
                    <div class="card">
                        <div class="card-body">
                            <div class="row mb-2">
                                <div class="profile-title">
                                    <div class="d-flex">
                                        <?php
                                            //*$image = auth()->user()->getFirstMedia('image');
                                            $image = ($CurrentUser->avatar) ? "/storage/avatares/" . $CurrentUser->avatar : '/storage/avatares/user.png';
                                        ?>

                                        <?php if(isset($image)): ?>
                                            <img src="<?php echo e($image); ?>" alt="Image" class="img-70 rounded-circle">
                                        <?php endif; ?>
                                        <div class="flex-grow-1">
                                            <h5 class="mb-1">
                                                <?php echo e($CurrentUser->propietario); ?>

                                            </h5>
                                            <p><?php echo e(session('rol')); ?></p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <hr>
                        </div>
                    </div>
                </div>
                <!--Aqui termiala seccion de la derecha-->
            </div>
            <!--Aqui comienza la otra tarjeta de la izquierda..lista de copropiedades-->
            <div class="row">
                <div class="card col-xl-8">
                    <div class="card-header">
                        <h4 class="card-title mb-0">Autorizaciones</h4>
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option f-16">
                                <li><i class="icon-more-alt"></i></li>
                                <li><a href="#"><i class="icofont icofont-maximize full-card"></i></a></li>
                                <li><a href="#"><i class="icofont icofont-minus minimize-card"></i></a></li>
                            </ul>
                        </div>
                    </div>
                    <div class="card-body"></div>
                        <div class="row mb-2">
                            <div class="col-md-12">
                                <div class="table-responsive">
                                    <table class="display dataTable" style="font-size: 11px;" id="ListCoop" width="100%" >
                                        <thead>
                                            <tr>
                                                <th >...</th>
                                                <th >CLIENTE</th>
                                                <th >UNIDADES</th>
                                                <th >AUTORIZACIÓN</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $__currentLoopData = $MasterCustomer; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $Mc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                <tr>
                                                    <td><?php echo e($loop->iteration); ?></td>
                                                    <td><?php echo e($Mc->nombre); ?></td>
                                                    <td><?php echo e($Mc->unidades); ?></td>
                                                    <td>
                                                        <div class="form-check-size">
                                                            <div class="form-check form-switch form-check-inline">
                                                                <?php if($Mc->Permitido == 'SI'): ?>
                                                                        <input class="form-check-input check-size" id="<?php echo e($Mc->id_agrupacion); ?>" type="checkbox" role="switch" checked="checked" title="Acceso permitido" onchange="SetAccesToCustomer('<?php echo e($Mc->id_agrupacion); ?>');">
                                                                <?php else: ?>
                                                                        <input class="form-check-input check-size" id="<?php echo e($Mc->id_agrupacion); ?>" type="checkbox" role="switch" title="Acceso Denegado" onchange="SetAccesToCustomer('<?php echo e($Mc->id_agrupacion); ?>');">
                                                                <?php endif; ?>
                                                            </div>
                                                        </div>
                                                    </td>
                                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
             <!--Alert Post AJAX-->
             <?php echo $__env->make('Alerts.AlertToast', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
        </div>



<?php $__env->stopSection(); ?>
<?php $__env->startSection('scripts'); ?>
    <script src="<?php echo e(asset('assets/js/vendors/clipboard/dist/clipboard.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/prism/prism.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/custom-card/custom-card.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/jquery.dataTables.min.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/datatable/datatables/datatables.gestor.js')); ?>"></script>
    <script src="<?php echo e(asset('assets/js/gestor.js')); ?>"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.master_main', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Dev\Laravel12\Gestor\resources\views/Admin/EditUser.blade.php ENDPATH**/ ?>