@extends('layouts.master_login')

@section('others_css')
@endsection
@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/scrollbar.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/wowjs/css/libs/animate.css') }}">
@endsection

@section('others_content')
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-7 login_one_image"><img class="bg-img-cover bg-center"
                    src="{{ asset('assets/images/login/21.jpg') }}" alt="looginpage"></div>
            <div class="col-xl-5 p-0">
                <div class="login-card login-dark login-bg">
                    <div>
                        <div><a class="logo" href="#" ><img class="img-fluid for-light"
                                    src="{{ asset('assets/images/logo/logo.png') }}" alt="looginpage"><img
                                    class="for-dark m-auto" src="{{ asset('assets/images/logo/logo.png') }}"
                                    alt="logo" ></a></div>
                        <div class="login-main">
                            <form class="theme-form row g-3 custom-input" novalidate="" method="post" action="{{route('LogIn.Join')}}">
                                @csrf
                                <h2 class="text-center">Acceso al Sistema</h2>
                                <p class="text-center">Ingresa tu e-mail &amp; Contraseña para acceder</p>
                                <div class="form-group">
                                    <label class="col-form-label" for="ValidateEmail">E-mail</label>
                                    <input class="form-control"
                                        type="email" id="ValidateEmail"
                                        name="ValidateEmail"
                                        required=""
                                        placeholder="tucorreo@aserprho.com"
                                        value="{{old('ValidateEmail')}}">
                                        @error('ValidateEmail')
                                            <div class="font-danger mb-0">{{$message}}</div>
                                        @enderror
                                        @if($ErrorMsg)
                                            <div class="alert alert-danger alert-dismissible" role="alert">
                                                <div>{{$ErrorMsg}}</div>
                                                <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                                            </div>
                                        @endif
                                </div>
                                <div class="form-group">
                                    <label class="col-form-label" for="ValidatePasswd">Contraseña</label>
                                    <div class="form-input position-relative">
                                        <input class="form-control"
                                            type="password"
                                            name="ValidatePasswd"
                                            id="ValidatePasswd"
                                            required=""
                                            placeholder="*********"
                                            value="{{old('ValidatePasswd')}}">
                                        <div class="show-hide">
                                            <span class="show"> </span>
                                        </div>
                                    </div>
                                     @error('ValidatePasswd')
                                            <div class="font-danger mb-0">{{$message}}</div>
                                     @enderror
                                </div>
                                <div class="form-group mb-0 checkbox-checked">
                                    <div class="form-check checkbox-solid-info">
                                        <input class="form-check-input" id="solid6" type="checkbox">
                                        <label class="form-check-label" for="solid6">Guardar Contraseña </label>
                                    </div><a class="link-two" href="#">Olvidaste tu contraseña?</a>
                                    <div class="text-end mt-3">
                                        <button class="btn btn-primary btn-block w-100 text-white" type="submit">Conectar</button>
                                </div>

                                <p class="mt-4 mb-0 text-center">Aun no tienes una cuenta? <a class="ms-2"
                                        href="#">Crear una cuenta</a></p>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('others_scripts')
    <script src="{{ asset('assets/js/password.js') }}"></script>
@endsection
