@extends('layouts.master_main')
@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/prism.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/scrollbar.css') }}">
@endsection


@section('main_content')
    <div class="container-fluid">
        <div class="row page-title">
            <div class="col-sm-6">
                <h3>Administrar Usuarios</h3>
            </div>
            <div class="col-sm-6">
                <nav>
                    <ol class="breadcrumb justify-content-sm-end align-items-center">
                        <li class="breadcrumb-item"> <a href="{{route('Main.Desktop')}}">
                                <svg class="svg-color">
                                    <use href="{{ asset('assets/svg/iconly-sprite.svg#Home') }}"></use>
                                </svg></a></li>
                        <li class="breadcrumb-item">Sistema</li>
                        <li class="breadcrumb-item active">Usuarios</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>

    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12">
                <div class="card">
                    <div class="card-header">
                        <div class="card-header-right">
                            <ul class="list-unstyled card-option f-16">
                                <li><i class="icon-more-alt"></i></li>
                                <!--<li><i class="view-html fa fa-code"></i></li>-->
                                <li><a href="{{route('System.NewUser')}}" title="Nuevo"><i class="icofont icofont-plus-circle"></i></a></li>
                                <li><a href="{{route('Extract.Users')}}" title="Exportar lista"><i class="icofont icofont-download-alt"></i></a></li>
                                <li><a href="#"><i class="icofont icofont-maximize full-card"></i></a></li>
                                <li><a href="#"><i class="icofont icofont-minus minimize-card"></i></a></li>
                                <!--<li><i class="icofont icofont-refresh reload-card"></i></li>
                                <li><i class="icofont icofont-error close-card"></i></li> -->
                            </ul>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="d-flex align-items-center gap-3 pills-blogger">
                            <div class="col-sm-12">
                                <form class="form theme-form raise-form">
                                            <div class="table-responsive">
                                                <table class="display" id="UserMaster" width="100%" >
                                                    <thead>
                                                        <tr>
                                                            <th >NOMBRE DE USUARIO</th>
                                                            <th >PROPIETARIO</th>
                                                            <th >ROL</th>
                                                            <th >ESTADO</th>
                                                            <th >ACTUALIZADO</th>
                                                            <th >...</th>
                                                        </tr>
                                                    </thead>
                                                    <tbody>
                                                        @foreach ($Usuarios as $User )
                                                            <tr>
                                                                <td>{{$User->cuenta}}</td>
                                                                <td>
                                                                    <div class="d-flex align-items-center gap-2">
                                                                        <div class="flex-shrink-0"><img class="b-r-10" src="{{($User->avatar) ? "storage/avatares/" . $User->avatar : 'storage/avatares/user.png'}}" alt="">
                                                                        </div>
                                                                        <div class="flex-grow-1">
                                                                            <a href="{{route('System.EditUser', ['IdUser'=>$User->id_usuario])}}">
                                                                                <h6 class="f-w-500">{{$User->propietario}}</h6>
                                                                            </a>
                                                                            <span class="font-light f-w-400 f-13">{{$User->correo_electronico}}</span>
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td>
                                                                    <select name="sel_role" class="form-select sel-access-level" style="font-size: 10px;" onchange="SetRole('{{$User->id_usuario}}');">
                                                                        <option value = "{{$User->id_perfil}}" selected >{{$User->rol}}</option>
                                                                        @foreach ($Roles as $Rol )
                                                                            @if ($User->id_perfil != $Rol->id_perfil)
                                                                                <option value = "{{$Rol->id_perfil}}"  >{{$Rol->nombre}}</option>
                                                                            @endif
                                                                        @endforeach

                                                                    </select>
                                                                </td>
                                                                <td>
                                                                    <div class="form-check-size">
                                                                        <div class="form-check form-switch form-check-inline">
                                                                            @if($User->id_estado == 'CA')
                                                                                    <input class="form-check-input check-size" id="{{$User->id_usuario}}" type="checkbox" role="switch" checked="checked" title="Estado de la Cuenta" onchange="SetStatusUserTable('{{$User->id_usuario}}');">
                                                                            @else
                                                                                    <input class="form-check-input check-size" id="{{$User->id_usuario}}" type="checkbox" role="switch" title="Estado de la Cuenta" onchange="SetStatusUserTable('{{$User->id_usuario}}');">
                                                                            @endif
                                                                        </div>
                                                                    </div>
                                                                </td>
                                                                <td>{{$User->fuc}}</td>
                                                                <td>
                                                                    <a href="{{route('System.EditUser',['IdUser'=>$User->id_usuario])}}"
                                                                        class="m-0 btn-xs p-1 btn-outline-primary"
                                                                        type="button"
                                                                        title="Editar este registro"
                                                                        ><i class="icofont icon-pencil font-dark "></i>
                                                                    </a>
                                                                </td>
                                                            </tr>
                                                        @endforeach
                                                    </tbody>
                                                </table>
                                            </div>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid ends-->
     <!--Alert Post AJAX-->
    @include('Alerts.AlertToast')
@endsection

@section('scripts')
    <script src="{{ asset('assets/js/vendors/clipboard/dist/clipboard.min.js') }}"></script>
    <script src="{{ asset('assets/js/clipboard/clipboard-script.js') }}"></script>
    <script src="{{ asset('assets/js/prism/prism.min.js') }}"></script>
    <script src="{{ asset('assets/js/custom-card/custom-card.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatables.gestor.js') }}"></script>
    <script src="{{ asset('assets/js/height-equal.js') }}"></script>
    <script src="{{ asset('assets/js/gestor.js') }}"></script>
@endsection
