        <div class="sm-12">
                <div class="collapse " id="FormEditResultados" >
                    <form name="FrmResultados" method = "post" action="{{route('System.SaveResultados')}}" class="theme-form row" novalidate>
                        @csrf
                        <input type="hidden" name="IdResultado" id="IdResultado">
                        <div class="card-body default-border mb-3">
                            <div class="row">
                                <div class="col-sm-6 ">
                                    <label class="form-label">Resultado de la Acción<span>*</span></label>
                                    <input class="form-control" type="text" name="NombreResultado" id="NombreResultado"
                                        value="" placeholder="Resultado de  la Acción" >
                                    @error('NombreResultado')
                                        <span class="text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="col-sm-4 ">
                                    <label class="form-label">Estado final de la Cartera</label>
                                    <select class="form-select" id="IdEstadoFinalResultado" name="IdEstadoFinalResultado" >
                                                @foreach ($EstadosCartera as $EC )
                                                        <option value = "{{$EC->id_estado}}" >{{$EC->nombre}}</option>
                                                @endforeach
                                    </select>
                                </div>
                                <div class="col-sm-2 ">
                                    <label class="form-label">Estado</label>
                                    <div class="form-check-size">
                                        <div class="form-check form-switch form-check-inline">
                                            <input class="form-check-input check-size"
                                            id="id_estado_resultado"
                                            name="id_estado_resultado"
                                            type="checkbox" role="switch"
                                            title="Estado del Registro" >
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer">
                            <div class="row">
                                <div class="text-end">
                                    <button class="btn btn-primary" type="submit">Actualizar</button>
                                    <button class="btn btn-dark" id="BtnCloseResultados" type="button"
                                    data-bs-toggle="collapse"
                                            data-bs-target="#FormEditResultados" aria-expanded="false"
                                            aria-controls="FormEditResultados" >Cerrar</button>
                                </div>
                            </div>
                        </div>
                        <hr>
                    </form>
                </div>
        </div>
        <div class="card p-2" >
            <div class="card-header-right">
                <button id="BtnNewResultado"
                class="btn m-1 font-dark btn-light btn-outline-light"
                >Nuevo Resultado</button>
                <a href="{{route('Extract.Resultados')}}" class="btn m-1 font-dark btn-light btn-outline-light">Exportar</a>
            </div>
            <div class="card-body">
                <div class="table-responsive">
                    <table class="display compact" id="TableResultados" width="100%" >
                        <thead>
                            <tr>
                                <th >ID</th>
                                <th >NOMBRE</th>
                                <th >E.CARTERA</th>
                                <th >ESTADO</th>
                                <th >...</th>
                            </tr>
                        </thead>
                        <tbody>
                            @foreach ($Resultados as $Resultado )
                                <tr>
                                    <td>{{$Resultado->id_resultado}}</td>
                                    <td>{{$Resultado->nombre}}</td>
                                    <td>{{$Resultado->estado_final}}</td>
                                    <td>
                                        <div class="form-check-size">
                                            <div class="form-check form-switch form-check-inline">
                                                @if($Resultado->control == 'A')
                                                        <input class="form-check-input check-size" id="{{$Resultado->id_resultado}}" type="checkbox" role="switch" checked="checked" title="Registro Activo" onchange="SetStatusResultado('{{$Resultado->id_resultado}}');">
                                                @else
                                                        <input class="form-check-input check-size" id="{{$Resultado->id_resultado}}" type="checkbox" role="switch" title="Registro Inactivo" onchange="SetStatusResultado('{{$Resultado->id_resultado}}');">
                                                @endif
                                            </div>
                                        </div>
                                    </td>
                                    <td>
                                            <button id="OpenClic" onclick="OpenFormEditResultado({{$Resultado->id_resultado}});"
                                                        class="m-0 btn-xs p-1 btn-outline-primary"
                                                        type="button"
                                                        data-bs-toggle="collapse"
                                                        data-bs-target="#FormEditResultados"
                                                        aria-expanded="false"
                                                        aria-controls="FormEditResultados"
                                                        title="Editar este registro"
                                                        ><i class="icofont icon-pencil font-dark "></i>
                                            </button>
                                        </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

