@extends('layouts.master_main')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/prism.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/scrollbar.css') }}">
@endsection

@section('main_content')
    <div class="container-fluid">
        <div class="row page-title">
            <div class="col-sm-6">
                <h3>Parámetros del sistema</h3>
            </div>
            <div class="col-sm-6">
                <nav>
                    <ol class="breadcrumb justify-content-sm-end align-items-center">
                        <li class="breadcrumb-item"> <a href="{{route('Main.Desktop')}}">
                                <svg class="svg-color">
                                    <use href="{{ asset('assets/svg/iconly-sprite.svg#Home') }}"></use>
                                </svg></a></li>
                        <li class="breadcrumb-item">Parámetros del Sistema</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
    <!--Alert de Actualización -->
    @include('Alerts.AlertUpdate')
    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-xl-12">
                <div class="card">

                    <div class="card-body">
                        <ul class="nav nav-tabs border-tab nav-primary mb-0" id="main-tab" role="tablist">
                            <li class="nav-item"><a class="nav-link nav-border font-info tab-info active"
                                    id="tab-1" data-bs-toggle="tab" href="#page-1" role="tab"
                                    aria-controls="page-1" aria-selected="true">
                                    <svg class="svg-color">
                                        <use href="{{ asset('assets/svg/iconly-sprite.svg#Document') }}"></use>
                                    </svg>Conceptos</a></li>
                            <li class="nav-item"><a class="nav-link nav-border font-info tab-info "
                                    id="tab-2" data-bs-toggle="tab" href="#page-2" role="tab"
                                    aria-controls="page-2" aria-selected="false">
                                    <svg class="svg-color">
                                        <use href="{{ asset('assets/svg/iconly-sprite.svg#Folder') }}"></use>
                                    </svg>Acciones</a></li>
                            <li class="nav-item"><a class="nav-link nav-border font-info tab-info"
                                    id="tab-3" data-bs-toggle="tab" href="#page-3" role="tab"
                                    aria-controls="page-3" aria-selected="false">
                                    <svg class="svg-color">
                                        <use href="{{ asset('assets/svg/iconly-sprite.svg#Contacts') }}"></use>
                                    </svg>Resultados</a></li>
                        </ul>
                        <div class="tab-content" id="main-tabContent">
                            <div class="tab-pane fade show active" id="page-1" role="tabpanel" aria-labelledby="tab-1">
                                <div class="card-body pt-3 p-0">
                                    @include('Admin.TableConceptos')
                                </div>
                            </div>

                            <div class="tab-pane fade" id="page-2" role="tabpanel"
                                aria-labelledby="bottom-contact-tab">
                                <div class="card-body pt-3 p-0">
                                    @include('Admin.TableAccioNes')
                                </div>
                            </div>

                            <div class="tab-pane fade " id="page-3" role="tabpanel"
                                aria-labelledby="bottom-inbox-tab">
                                <div class="card-body pt-3 p-0">
                                    @include('Admin.TableResultados')
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid ends-->
    <!--Alert Post AJAX-->
    @include('Alerts.AlertToast')
@endsection

@section('scripts')
    <script src="{{ asset('assets/js/vendors/clipboard/dist/clipboard.min.js') }}"></script>
    <script src="{{ asset('assets/js/clipboard/clipboard-script.js') }}"></script>
    <script src="{{ asset('assets/js/prism/prism.min.js') }}"></script>
    <script src="{{ asset('assets/js/custom-card/custom-card.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatables.gestor.js') }}"></script>
    <script src="{{ asset('assets/js/height-equal.js') }}"></script>
    <script src="{{ asset('assets/js/gestor.js') }}"></script>
@endsection
