@extends('layouts.master_main')
@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/scrollbar.css') }}">
@endsection


@section('main_content')
    <div class="container-fluid">
        <div class="row page-title">
            <div class="col-sm-6">
                <h3>Roles de Usuario</h3>
            </div>
            <div class="col-sm-6">
                <nav>
                    <ol class="breadcrumb justify-content-sm-end align-items-center">
                        <li class="breadcrumb-item"> <a href="{{route('Main.Desktop')}}">
                                <svg class="svg-color">
                                    <use href="{{ asset('assets/svg/iconly-sprite.svg#Home') }}"></use>
                                </svg></a></li>
                        <li class="breadcrumb-item">Sistema</li>
                        <li class="breadcrumb-item"><a href="{{route('System.Roles')}}">Roles de Usuario</a></li>
                        <li class="breadcrumb-item">Editar Roles</li>
                    </ol>
                </nav>
            </div>
        </div>
    </div>
     <!--Alert de Actualización -->
    @include('Alerts.AlertUpdate')

    <!-- Container-fluid starts-->
    <div class="container-fluid">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body">
                        <div class="col-sm-12">
                                <form name="FrmRoles" class="theme-form row g-3" action="{{route('System.UpdateRoles', ['IdRol'=>null])}}" method="POST">
                                    @csrf
                                    <div class="col-sm-4 ">
                                                <label class="form-label">Nombre del Rol<span> *</span></label>
                                                <input class="form-control" type="text" name="nombre"
                                                        value="{{old('nombre')}}" placeholder="Nombre del Rol">
                                                    @error('nombre')
                                                        <span class="text-danger">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                    </div>
                                    <div class="col-sm-4">
                                                <label class="form-label">Proposito<span> *</span></label>
                                                <input class="form-control" type="text" name="proposito"
                                                        value="{{old('proposito')}}" placeholder="Proposito del rol">
                                                    @error('proposito')
                                                        <span class="text-danger">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                    </div>
                                    <div class="col-sm-4">
                                                <label class="form-label">Aplicación<span> *</span></label>
                                                <input class="form-control" type="text" name="aplicacion"
                                                        value="{{old('aplicacion')}}" placeholder="Aplicacion">
                                                    @error('aplicacion')
                                                        <span class="text-danger">
                                                            <strong>{{ $message }}</strong>
                                                        </span>
                                                    @enderror
                                    </div>
                                    <div class="col-sm-1">
                                        <button class="btn m-1 btn-outline-primary" type="submit"
                                                title="Guardar">Guardar</button>
                                    </div>
                                </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- Container-fluid ends-->
@endsection

@section('scripts')
    <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
    <script src="{{ asset('assets/js/datatable/datatables/datatables.gestor.js') }}"></script>
@endsection
