@extends('layouts.master_main')

@section('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/scrollbar.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/vendors/select2/dist/css/select2.css') }}">
@endsection

@section('main_content')
<div class="container-fluid">
  <div class="row page-title">
      <div class="col-sm-6">
          <h3>Datos de Usuario</h3>
      </div>
      <div class="col-sm-6">
          <nav>
              <ol class="breadcrumb justify-content-sm-end align-items-center">
                  <li class="breadcrumb-item"> <a href="{{route('Main.Desktop')}}">
                          <svg class="svg-color">
                              <use href="{{ asset('assets/svg/iconly-sprite.svg#Home') }}"></use>
                          </svg></a></li>
                  <li class="breadcrumb-item">Mi Perfil de Usuario</li>
              </ol>
          </nav>
      </div>
  </div>
</div>
<!--Alert de Actualización -->
@include('Alerts.AlertUpdate')

    <!-- Container-fluid starts-->
        <div class="container-fluid edit-profile">
            <div class="row">
                <div class="card col-xl-4">
                        <div class="card-header">
                            <!-- <h4 class="card-title mb-0">My Profile</h4> -->
                            <div class="card-options"><a class="card-options-collapse" href="#"
                                    data-bs-toggle="card-collapse"><i class="fe fe-chevron-up"></i></a><a
                                    class="card-options-remove" href="#" data-bs-toggle="card-remove"><i
                                        class="fe fe-x"></i></a></div>
                        </div>
                        <div class="card-body">
                            <div class="row mb-2">
                                <div class="profile-title">
                                    <div class="d-flex">
                                        @php
                                            //*$image = auth()->user()->getFirstMedia('image');
                                            $image = session('avatar')
                                        @endphp

                                        @isset($image)
                                            <img src="{{ $image}}" alt="Image" class="img-70 rounded-circle">
                                        @endisset
                                        <div class="flex-grow-1">
                                            <h5 class="mb-1">
                                                {{ $CurrentUser->propietario }}
                                            </h5>
                                            <p>{{ session('rol') }}</p>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <form action="{{route('Profile.UpdateImageProfile')}}" method="post" enctype="multipart/form-data" novalidate>
                                @csrf
                                <div class="mb-3">
                                    <label class="form-label">Foto</label>
                                    <input class="form-control form-control-sm" type="file" name="image" value="{{session('avatar')}}">
                                    @error('image')
                                        <span class="text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="mb-3 text-end">
                                    <button class="btn btn-outline-primary" type="submit">Actualizar Imagen</button>
                                </div>
                                <hr>
                            </form>
                            <form action="{{route('Profile.UpdatePasswd')}}" method="post"  novalidate>
                                @csrf
                                <div class="mb-3">
                                    <label class="form-label">Password</label>
                                    <input class="form-control" type="password" name="password" placeholder="Escriba una contraseña"
                                        value="{{old('password')}}">
                                    @error('password')
                                        <span class="text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label class="form-label">Confirmar Password</label>
                                    <input class="form-control" type="password" name="confirm_password"
                                        placeholder="Confirme la contraseña" value="{{old('confirm_password')}}">
                                    @error('confirm_password')
                                        <span class="text-danger">
                                            <strong>{{ $message }}</strong>
                                        </span>
                                    @enderror
                                </div>
                                <div class="mb-3 text-end">
                                    <button class="btn btn-outline-primary" type="submit">Cambiar Password</button>
                                </div>
                                <hr>
                            </form>
                        </div>
                </div>

                <div class="card col-xl-8">
                    <!--Form Actualizar Profile-->
                    <form action="{{route('Profile.UpdateProfile')}}" method="post"  novalidate>
                        @csrf
                        <div class="card-header card-header ">
                            <h4 class="card-title mb-0">Datos de Contacto</h4>
                            <div class="card-options"><a class="card-options-collapse" href="#"
                                    data-bs-toggle="card-collapse"><i class="fe fe-chevron-up"></i></a><a
                                    class="card-options-remove" href="#" data-bs-toggle="card-remove"><i
                                        class="fe fe-x"></i></a></div>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-sm-6 col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">E-mail</label>
                                        <input class="form-control" placeholder="your-email@domain.com" name="email"
                                            value="{{$CurrentUser->cuenta}}">
                                        @error('email')
                                            <span class="text-danger">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">E-mail alternativo<span> *</span></label>
                                        <input class="form-control" type="email" placeholder="Email" name="email2"
                                            value="{{ $CurrentUser->correo_electronico }}">
                                        @error('email2')
                                            <span class="text-danger">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6 col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Nombre completo<span> *</span></label>
                                        <input class="form-control" type="text" placeholder="Nombre completo" name="fullname"
                                            value="{{ $CurrentUser->propietario }}">
                                        @error('fullname')
                                            <span class="text-danger">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Teléfono fijo</label>
                                        <input class="form-control" type="number" placeholder="Telefono" name="telfijo"
                                            value="{{ $CurrentUser->telefono }}">
                                        @error('telfijo')
                                            <span class="text-danger">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-sm-6 col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Domicilio</label>
                                        <input class="form-control" type="text" placeholder="Direccion" name="domicilio"
                                            value="{{$CurrentUser->domicilio}}">
                                        @error('domicilio')
                                            <span class="text-danger">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Teléfono Móvil<span> *</span></label>
                                        <input class="form-control" type="number" name="celular"
                                            value="{{ $CurrentUser->celular}}" placeholder="Número de Móvil">
                                        @error('celular')
                                            <span class="text-danger">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                                <div class="col-sm-6 col-md-6">
                                    <div class="mb-3">
                                        <label class="form-label">Ciudad</label>
                                        <input class="form-control" type="text" placeholder="Ciudad" name="ciudad"
                                            value="{{$CurrentUser->ciudad}}">
                                        @error('ciudad')
                                            <span class="text-danger">
                                                <strong>{{ $message }}</strong>
                                            </span>
                                        @enderror
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-footer text-end">
                            <button class="btn btn-primary" type="submit">Actualizar Perfil</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    <!-- Container-fluid ends-->
@endsection
