// gridjs
var dataSet = [
    [
      "Tiger Nixon",
      "System Architect",
      "Edinburgh",
      "Female",
      "5421",
      "2019/04/25",
      "$320,800",
    ],
    [
      "Garrett Winters",
      "Accountant",
      "Tokyo",
      "Male",
      "8422",
      "2019/07/25",
      "$170,750",
    ],
    [
      "Ashton Cox",
      "Junior Technical Author",
      "San Francisco",
      "Male",
      "1562",
      "2022/01/12",
      "$86,000",
    ],
    [
      "Cedric Kelly",
      "Senior Javascript Developer",
      "Edinburgh",
      "Female",
      "6224",
      "2023/03/29",
      "$433,060",
    ],
    ["Airi Satou", "Accountant", "Tokyo","Female", "5407", "2021/11/28", "$162,700"],
    [
      "Brielle Williamson",
      "Integration Specialist",
      "New York",
      "Male",
      "4804",
      "2023/12/02",
      "$372,000",
    ],
    [
      "Herrod Chandler",
      "Sales Assistant",
      "San Francisco",
      "Female",
      "9608",
      "2023/08/06",
      "$137,500",
    ],
    [
      "Rhona Davidson",
      "Integration Specialist",
      "Tokyo",
      "Male",
      "6200",
      "2020/10/14",
      "$327,900",
    ],
    [
      "Colleen Hurst",
      "Javascript Developer",
      "San Francisco",
      "Male",
      "2360",
      "2022/09/15",
      "$205,500",
    ],
    [
      "Sonya Frost",
      "Software Engineer",
      "Edinburgh",
      "Male",
      "1667",
      "2021/12/13",
      "$103,600",
    ],
    [
      "Jena Gaines",
      "Office Manager",
      "London",
      "Female",
      "3814",
      "2021/12/19",
      "$90,560",
    ],
    [
      "Quinn Flynn",
      "Support Lead",
      "Edinburgh",
      "Female",
      "9497",
      "2022/03/03",
      "$342,000",
    ],
    [
      "Charde Marshall",
      "Regional Director",
      "San Francisco",
      "Male",
      "6741",
      "2021/10/16",
      "$470,600",
    ],
    [
      "Haley Kennedy",
      "Senior Marketing Designer",
      "London",
      "Male",
      "3597",
      "2023/12/18",
      "$313,500",
    ],
    [
      "Tatyana Fitzpatrick",
      "Regional Director",
      "London",
      "Male",
      "1965",
      "2020/03/17",
      "$385,750",
    ],
    [
      "Michael Silva",
      "Marketing Designer",
      "London",
      "Female",
      "1581",
      "2023/11/27",
      "$198,500",
    ],
    [
      "Paul Byrd",
      "Chief Financial Officer (CFO)",
      "New York",
      "Female",
      "3059",
      "2020/06/09",
      "$725,000",
    ],
    [
      "Gloria Little",
      "Systems Administrator",
      "New York",
      "Female",
      "1721",
      "2022/04/10",
      "$237,500",
    ],
    [
      "Bradley Greer",
      "Software Engineer",
      "London",
      "Male",
      "2558",
      "2023/10/13",
      "$132,000",
    ],
    [
      "Dai Rios",
      "Personnel Lead",
      "Edinburgh",
      "Male",
      "2290",
      "2023/09/26",
      "$217,500",
    ],
    [
      "Jenette Caldwell",
      "Development Lead",
      "New York",
      "Female",
      "1937",
      "2019/09/03",
      "$345,000",
    ],
    [
      "Yuri Berry",
      "Chief Marketing Officer (CMO)",
      "New York",
      "Female",
      "6154",
      "2022/06/25",
      "$675,000",
    ],
    [
      "Caesar Vance",
      "Pre-Sales Support",
      "New York",
      "Female",
      "8330",
      "2019/12/12",
      "$106,450",
    ],
    [
      "Doris Wilder",
      "Sales Assistant",
      "Sidney",
      "Male",
      "3023",
      "2020/09/20",
      "$85,600",
    ],
    [
      "Angelica Ramos",
      "Chief Executive Officer (CEO)",
      "London",
      "Male",
      "5797",
      "2022/10/09",
      "$1,200,000",
    ],
    [
      "Gavin Joyce",
      "Developer",
      "Edinburgh",
      "Female",
      "8822",
      "2020/12/22",
      "$92,575",
    ],
    [
      "Jennifer Chang",
      "Regional Director",
      "Singapore",
      "Female",
      "9239",
      "2020/11/14",
      "$357,650",
    ],
    [
      "Brenden Wagner",
      "Software Engineer",
      "San Francisco",
      "Female",
      "1314",
      "2019/06/07",
      "$206,850",
    ],
    [
      "Fiona Green",
      "Chief Operating Officer (COO)",
      "San Francisco",
      "Female",
      "2947",
      "2020/03/11",
      "$850,000",
    ],
    [
      "Shou Itou",
      "Regional Marketing",
      "Tokyo",
      "Male",
      "8899",
      "2019/08/14",
      "$163,000",
    ],
    [
      "Michelle House",
      "Integration Specialist",
      "Sidney",
      "Male",
      "2769",
      "2019/06/02",
      "$95,400",
    ],
    ["Suki Burks", "Developer", "London","Female", "6832", "2022/10/22", "$114,500"],
    [
      "Prescott Bartlett",
      "Technical Author",
      "London",
      "Male",
      "3606",
      "2019/05/07",
      "$145,000",
    ],
    [
      "Gavin Cortez",
      "Team Leader",
      "San Francisco",
      "Male",
      "2860",
      "2021/10/26",
      "$235,500",
    ],
    [
      "Martena Mccray",
      "Post-Sales support",
      "Edinburgh",
      "Male",
      "8240",
      "2019/03/09",
      "$324,050",
    ],
    [
      "Unity Butler",
      "Marketing Designer",
      "San Francisco",
      "Male",
      "5384",
      "2022/12/09",
      "$85,675",
    ],
  ];

new gridjs.Grid({
    columns: ["Name", "Position", "Office","Gender", "Extn.","Start date", "Salary"],
    search: true,
    sort: true,
    pagination: true,
    resizable: true,
    data: dataSet,
  }).render(document.getElementById("gridtable-1"));
  

new gridjs.Grid({
    sort: true,
    search: true,
    pagination: true,
    columns: ['Location', 'Change Frequency', 'Priority'],
    server: {
      url: 'https://gridjs.io/sitemap.xml',
      handle: (res) => {
        return res.text().then(str => (new window.DOMParser()).parseFromString(str, "text/xml"));
      },
      then: data => {
        return Array.from(data.querySelectorAll('url'))
          .map(row => [
            row.querySelector('loc').innerHTML,
            row.querySelector('changefreq').innerHTML,
            row.querySelector('priority').innerHTML,
          ]);
      }
    }
  }).render(document.getElementById("gridtable-2"));

new gridjs.Grid({
  sort: true,
  pagination: true,
    columns: ['Name', 'Language', 'Released At', 'Artist'],
    server: {
      url: 'https://api.scryfall.com/cards/search?q=Inspiring',
      then: data => data.data.map(card => [card.name, card.lang, card.released_at, card.artist])
    } 
  }).render(document.getElementById("gridtable-3"));
