<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateAgrupacionRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'Nit'=> 'required|max:20',
            'Nombre' => 'required|max:90',
            'NombreComercial' => 'required|max:190',
            'Domicilio' => 'required|max:190',
            'Telefono' => 'required',
            'Celular' => 'required',
            'Email' => 'required|email|max:145',
            'id_segmento'=>'required',
            'PercHonPre'=>'required|decimal:2|max:50.99',
            'PercHonJuridico'=>'required|decimal:2|max:50.99',
            'PercInteres'=>'required|decimal:2|max:50.99',
            'NumCuenta'=>'max:45',
            'id_banco'=>'required_if:NumCuenta,!=,""',
            'TipoCuenta'=>'required_if:id_banco,!=,-1',
            'id_owner'=>'required',
            'NombreAdministrador'=>'max:50'

        ];
    }
}
