<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class LogInRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }


    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'ValidateEmail'=> 'required|email|max:60',
            'ValidatePasswd'=> 'required|max:16|min:8'
        ];
    }
    /*
    public function messages()
    {
        return [
            'ValidateEmail.email '=> 'Debe ingresar un e-mail válido',
            'ValidateEmail.required '=> 'Debe ingresar un e-mail válido',
            'ValidatePasswd'=> 'La contraseña es requerida, max 16 caracteres'
        ];
    }
    */
}
